// Generated by CoffeeScript 1.10.0
(function() {
  var Exclusions, RegexpCache, parseLegacyRules, root;

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  RegexpCache = {
    cache: {},
    clear: function() {
      return this.cache = {};
    },
    get: function(pattern) {
      var regexp;
      if (regexp = this.cache[pattern]) {
        return regexp;
      } else {
        return this.cache[pattern] = (function() {
          var error;
          try {
            return new RegExp("^" + pattern.replace(/\*/g, ".*") + "$");
          } catch (error) {
            return /^$/;
          }
        })();
      }
    }
  };

  root.Exclusions = Exclusions = {
    RegexpCache: RegexpCache,
    rules: Settings.get("exclusionRules"),
    getRule: function(url, rules) {
      var i, len, matches, passKeys, rule;
      if (rules == null) {
        rules = this.rules;
      }
      matches = (function() {
        var i, len, results;
        results = [];
        for (i = 0, len = rules.length; i < len; i++) {
          rule = rules[i];
          if (rule.pattern && 0 <= url.search(RegexpCache.get(rule.pattern))) {
            results.push(rule);
          }
        }
        return results;
      })();
      for (i = 0, len = matches.length; i < len; i++) {
        rule = matches[i];
        if (!rule.passKeys) {
          return rule;
        }
      }
      passKeys = ((function() {
        var j, len1, results;
        results = [];
        for (j = 0, len1 = matches.length; j < len1; j++) {
          rule = matches[j];
          results.push(rule.passKeys.split(/\s+/).join(""));
        }
        return results;
      })()).join("");
      if (0 < matches.length) {
        return {
          pattern: ((function() {
            var j, len1, results;
            results = [];
            for (j = 0, len1 = matches.length; j < len1; j++) {
              rule = matches[j];
              results.push(rule.pattern);
            }
            return results;
          })()).join(" | "),
          passKeys: Utils.distinctCharacters(passKeys)
        };
      } else {
        return null;
      }
    },
    setRules: function(rules) {
      this.rules = rules.filter(function(rule) {
        return rule && rule.pattern;
      });
      return Settings.set("exclusionRules", this.rules);
    },
    postUpdateHook: function(rules1) {
      this.rules = rules1;
      return RegexpCache.clear();
    }
  };

  if (false && Settings.has("excludedUrlsBackup")) {
    Settings.clear("exclusionRules");
    Settings.set("excludedUrls", Settings.get("excludedUrlsBackup"));
  }

  if (!Settings.has("exclusionRules") && Settings.has("excludedUrls")) {
    parseLegacyRules = function(lines) {
      var i, len, line, parse, ref, results;
      ref = lines.trim().split("\n").map(function(line) {
        return line.trim();
      });
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        line = ref[i];
        if (line.length && line.indexOf("#") !== 0 && line.indexOf('"') !== 0) {
          parse = line.split(/\s+/);
          results.push({
            pattern: parse[0],
            passKeys: parse.slice(1).join("")
          });
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
    Exclusions.setRules(parseLegacyRules(Settings.get("excludedUrls")));
    if (!Settings.has("excludedUrlsBackup")) {
      Settings.set("excludedUrlsBackup", Settings.get("excludedUrls"));
    }
    Settings.clear("excludedUrls");
  }

  Settings.postUpdateHooks["exclusionRules"] = function(value) {
    return Exclusions.postUpdateHook(value);
  };

}).call(this);
